/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChildProcessStore {
    private static List<Object> origin = new CopyOnWriteArrayList<Object>();
    private static boolean hasModifiedOrigin = false;

    public List<ChildProcess> getAll() {
        ArrayList<ChildProcess> processes = new ArrayList<ChildProcess>();
        for (Object object : ChildProcessStore.getOrigin()) {
            processes.add((ChildProcess)object);
        }
        return processes;
    }

    public void add(ChildProcess process) {
        ChildProcessStore.getOrigin().add(process);
    }

    public void remove(ChildProcess process) {
        ChildProcessStore.getOrigin().remove(process);
    }

    public static List<Object> getOrigin() {
        return origin;
    }

    public static void setOrigin(List<Object> origin) {
        if (ChildProcesses.getAll().size() > 0) {
            throw new ChildProcessException("Can not set origin when child processes are running");
        }
        ChildProcessStore.origin = origin;
        ChildProcessStore.setHasModifiedOrigin(true);
    }

    public static boolean hasModifiedOrigin() {
        return hasModifiedOrigin;
    }

    private static void setHasModifiedOrigin(boolean modified) {
        hasModifiedOrigin = modified;
    }
}

