/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcessIsTerminatingException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.crash.CrashManager;
import com.gamedash.daemon.process.childProcess.io.Io;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.reference.ChildProcessReferences;
import com.gamedash.daemon.process.childProcess.resource.ChildProcessResourceLimitsException;
import com.gamedash.daemon.process.childProcess.terminal.IOnExitCallback;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.Terminal;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.shutdown.ShutdownManager;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.utilities.Os;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcess
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ChildProcess.class);
    private final Terminal terminal;
    private final ChildProcessReferences references;
    private final CrashManager crashManager;
    private final Time timeCreated = Time.now();
    private final Io io;
    private File workingDirectory;
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private IProcess process;
    private SystemUser systemUser;
    private boolean useShell = true;
    private boolean isSelfManaged = true;
    private boolean isTerminating = false;
    private boolean shouldReportCrashes = false;
    private boolean canInterrupt = true;

    public ChildProcess(Class<? extends ITerminal> terminalClass) throws Exception {
        this.terminal = new Terminal(this, terminalClass);
        this.references = new ChildProcessReferences(this);
        this.crashManager = new CrashManager(this);
        this.io = new Io(this);
        if (Os.isWindows()) {
            this.addEnvironmentVariable("PATH", System.getenv("path"));
        } else if (Os.isUnix() && System.getenv("LD_LIBRARY_PATH") != null) {
            this.addEnvironmentVariable("LD_LIBRARY_PATH", System.getenv("LD_LIBRARY_PATH"));
        }
    }

    public void spawn(String executable) throws Exception {
        this.spawn(executable, new String[0]);
    }

    public void spawn(String executable, String[] args) throws Exception {
        ArrayList<Object> spawnArgs = new ArrayList<Object>();
        if (Os.isUnix()) {
            if (this.isUsingShell()) {
                if (this.hasSystemUser()) {
                    spawnArgs.add("sudo");
                    spawnArgs.add("-S");
                    spawnArgs.add("-u");
                    spawnArgs.add(this.systemUser.getName());
                }
                spawnArgs.add("/bin/sh");
                spawnArgs.add("-c");
                spawnArgs.add(executable + " " + String.join((CharSequence)" ", args));
            } else {
                if (this.hasSystemUser()) {
                    SystemUser systemUser = this.getSystemUser();
                    spawnArgs.add("sudo");
                    spawnArgs.add("-S");
                    spawnArgs.add("-u");
                    spawnArgs.add(systemUser.getName());
                }
                spawnArgs.add(executable);
                Collections.addAll(spawnArgs, args);
            }
        } else {
            spawnArgs.add(executable);
            spawnArgs.addAll(Arrays.asList(args));
        }
        try {
            this.getIo().onOutput(this::handleIoOutput);
            this.getIo().onClose(this::handleIoClose);
            this.onExitWithPriority(this::handleExit);
            this.getTerminal().getInstance().spawn(spawnArgs.toArray(new String[0]));
            logger.debug("Spawning child process " + Arrays.toString(spawnArgs.toArray()) + " with id " + this.getId());
        }
        catch (Exception exception) {
            this.getReferences().removeAllLocal();
            throw exception;
        }
    }

    public void stop() throws Exception {
        block5: {
            if (!this.canInterrupt()) {
                throw new ChildProcessException("Can not interrupt child process");
            }
            if (this.isTerminating()) {
                throw new ChildProcessIsTerminatingException("Process is currently terminating");
            }
            if (!this.isRunning()) {
                throw new ChildProcessNotRunningException("Process is already not running any more");
            }
            this.setIsTerminating(true);
            try {
                this.getTerminal().getInstance().stop();
            }
            catch (Exception exception) {
                this.setIsTerminating(false);
                if (exception instanceof ProcessNotFoundException) break block5;
                throw exception;
            }
        }
        this.waitForExit();
    }

    public void kill() throws Exception {
        this.stop();
    }

    public int getExitCode() throws Exception {
        return this.getTerminal().getInstance().getExitCode();
    }

    public boolean isUsingShell() {
        return this.useShell;
    }

    public void setUseShell(boolean useShell) {
        this.useShell = useShell;
    }

    public IProcess getProcess() throws Exception {
        if (this.process == null) {
            this.process = Processes.get(this.getId());
        }
        return this.process;
    }

    public List<IProcess> getChildren() throws Exception {
        return this.getProcess().getChildren();
    }

    public List<ProcessHandle> getDescendants() throws Exception {
        return this.getTerminal().getInstance().getDescendants();
    }

    public CrashManager getCrashManager() {
        return this.crashManager;
    }

    public void delete() {
        this.getReferences().removeAllLocal();
        ChildProcesses.delete(this);
    }

    public void onExit(IOnExitCallback callback) {
        try {
            this.getTerminal().getInstance().onExit(callback);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    public void onExitWithPriority(IOnExitCallback callback) {
        try {
            this.getTerminal().getInstance().onExitWithPriority(callback);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    public void waitForExit() throws Exception {
        this.getTerminal().getInstance().waitForExit();
    }

    public boolean isRunning() throws Exception {
        return this.getTerminal().getInstance().isRunning();
    }

    public boolean hasExited() throws Exception {
        return this.getTerminal().getInstance().hasExited();
    }

    public Integer getId() {
        try {
            return this.getTerminal().getInstance().getId();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Io getIo() {
        return this.io;
    }

    public ProcessResourceUsageResult getResourceUsage() throws Exception {
        return this.getProcess().getResourceUsage();
    }

    public <T> T getApi(Class<T> type) throws Exception {
        return this.getTerminal().getInstance().getApi(type);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public ChildProcessReferences getReferences() {
        return this.references;
    }

    public boolean isTerminating() {
        return this.isTerminating;
    }

    private void setIsTerminating(boolean isTerminating) {
        this.isTerminating = isTerminating;
    }

    public boolean shouldReportCrashes() {
        return this.shouldReportCrashes;
    }

    public void setShouldReportCrashes(boolean shouldReportCrashes) {
        this.shouldReportCrashes = shouldReportCrashes;
    }

    public boolean isSelfManaged() {
        return this.isSelfManaged;
    }

    public void setIsSelfManaged(boolean isSelfManaged) {
        this.isSelfManaged = isSelfManaged;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Boolean hasWorkingDirectory() {
        return this.workingDirectory != null;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public SystemUser getSystemUser() {
        return this.systemUser;
    }

    public boolean hasSystemUser() {
        return this.systemUser != null;
    }

    public void setSystemUser(SystemUser systemUser) {
        this.systemUser = systemUser;
    }

    public boolean canInterrupt() {
        return this.canInterrupt;
    }

    public void setCanInterrupt(boolean canInterrupt) {
        this.canInterrupt = canInterrupt;
    }

    public void setCPUResourceLimit(CPUResourceLimit cpu) throws Exception {
        this.getProcess().setCPUResourceLimit(cpu);
    }

    public void setRAMResourceLimit(RAMResourceLimit ram) throws Exception {
        this.getProcess().setRAMResourceLimit(ram);
    }

    public void setDiskResourceLimit(DiskResourceLimit disk) throws Exception {
        this.getProcess().setDiskResourceLimit(disk);
    }

    public Time getTimeCreated() {
        return this.timeCreated;
    }

    public boolean equals(Object value) {
        return value instanceof ChildProcess && ((ChildProcess)value).getId().equals(this.getId());
    }

    @Override
    public void close() throws Exception {
        if (this.isRunning()) {
            this.waitForExit();
        }
        this.delete();
    }

    private void destroyResourceLimits() throws ChildProcessResourceLimitsException {
        try {
            IProcess process = this.getProcess();
            process.destroyResourceLimits();
        }
        catch (Exception e) {
            throw new ChildProcessResourceLimitsException("Could not destroy resource limits: " + e.getMessage());
        }
    }

    private void safeDestroyResourceLimits() {
        try {
            this.destroyResourceLimits();
        }
        catch (ChildProcessResourceLimitsException e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    private void handleExit() {
        try {
            try {
                boolean shouldReportCrash;
                logger.info("Child process " + this.getId() + " has exited with code " + this.getExitCode());
                this.getIo().destroy();
                this.safeDestroyResourceLimits();
                if (Application.args.logChildProcess.booleanValue()) {
                    logger.info(MessageFormat.format("Destroyed resource limits for child process {0,number,#}", this.getId()));
                    logger.info(MessageFormat.format("Destroyed IO for child process {0,number,#}", this.getId()));
                }
                boolean bl = shouldReportCrash = this.shouldReportCrashes() && !this.isTerminating() && !ShutdownManager.isShuttingDown();
                if (shouldReportCrash) {
                    if (Application.args.logChildProcess.booleanValue()) {
                        logger.info(MessageFormat.format("Reporting process crash for process {0,number,#}", this.getId()));
                    }
                    this.crashManager.queueReport(this.crashManager.createReport());
                }
            }
            finally {
                this.getReferences().removeAllLocal();
                if (this.isSelfManaged()) {
                    this.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    private void handleIoOutput(OutputItem item) {
        this.getIo().getListeners().forEach(listener -> {
            try {
                listener.onOutput(item);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
    }

    private void handleIoClose() {
        this.getIo().getListeners().forEach(listener -> {
            try {
                listener.onClose();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
    }
}

