/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.DataLayer;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcessException;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcesses;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformResourceProcessUsage;
import com.gamedash.daemon.platform.windows.process.priority.WindowsPlatformProcessPriorityEnum;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsPlatformProcess {
    private int id;
    private WindowsPlatformResourceProcessUsage usage;
    public DataLayer dataLayer = new DataLayer(this);

    public WindowsPlatformProcess(int id) {
        this.id = id;
        this.usage = new WindowsPlatformResourceProcessUsage(this);
    }

    public int getId() {
        return this.id;
    }

    public String getName() throws Exception {
        return (String)this.dataLayer.getValue("name");
    }

    public String getFileName() throws Exception {
        return (String)this.dataLayer.getValue("fileName");
    }

    public String[] getArguments() throws Exception {
        return (String[])this.dataLayer.getValue("arguments");
    }

    public File getWorkingDirectory() throws Exception {
        return (File)this.dataLayer.getValue("workingDirectory");
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killProcess(this.getId()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
    }

    public List<WindowsPlatformProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessChildren(this.getId()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsPlatformProcess> processes = new ArrayList<WindowsPlatformProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsPlatformProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public void setProcessorAffinity(List<Processor> processors) throws Exception {
        this.setProcessorAffinity(Processors.toMask(processors));
    }

    public void setProcessorAffinity(long mask) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessProcessorAffinity(this.getId(), mask));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
    }

    public WindowsPlatformProcessPriorityEnum getPriority() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessPriority(this.getId()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        int integer = result.getResultValueAsInteger();
        for (WindowsPlatformProcessPriorityEnum priority : WindowsPlatformProcessPriorityEnum.values()) {
            if (priority.getInteger() != integer) continue;
            return priority;
        }
        return null;
    }

    public void setPriority(WindowsPlatformProcessPriorityEnum priority) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessPriority(this.getId(), priority.getInteger()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
    }

    public WindowsPlatformResourceProcessUsage getResourceUsage() {
        return this.usage;
    }
}

