/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.system.user;

import com.gamedash.daemon.platform.linux.system.user.LinuxSystemUser;
import com.gamedash.daemon.platform.linux.system.user.LinuxSystemUserException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.system.user.ISystemUsers;
import java.util.List;

public class LinuxSystemUsers
implements ISystemUsers {
    @Override
    public boolean exists(String name) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("id", new String[]{"\"" + name + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0 && childProcess.getExitCode() != 1) {
            throw new LinuxSystemUserException("Could not check if user exists");
        }
        List<OutputItem> outputItems = childProcess.getIo().getOutputItems();
        if (outputItems.size() < 1) {
            throw new LinuxSystemUserException("Could not check whether user exists. No output received from query.");
        }
        OutputItem lastItem = outputItems.get(outputItems.size() - 1);
        if (lastItem.getValue().length() < 1) {
            throw new LinuxSystemUserException("Could not check whether user exists. Output was empty.");
        }
        return lastItem.getValue().charAt(0) == 'u';
    }

    @Override
    public LinuxSystemUser create(String name, String password) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("useradd", new String[]{"-p", "$(openssl passwd -1 \"" + password + "\")", "\"" + name + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not create");
        }
        return this.get(name);
    }

    @Override
    public LinuxSystemUser get(String name) {
        return new LinuxSystemUser(name);
    }
}

