/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages;

import com.gamedash.daemon.platform.linux.LinuxDistroEnum;
import com.gamedash.daemon.platform.linux.LinuxPlatform;
import com.gamedash.daemon.platform.linux.LinuxPlatformRelease;
import com.gamedash.daemon.platform.linux.packageManager.packages.AlreadyPropagatingPackageInstallException;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.CentOS;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.Debian;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.IDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.RHEL;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.Ubuntu;
import java.util.concurrent.locks.ReentrantLock;

public class LinuxPackage {
    private static final ReentrantLock installPropagationLock = new ReentrantLock();
    private final String name;
    private IDistro flavorInstance;

    public LinuxPackage(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void install() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                this.getInstance().install();
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }

    public void uninstall() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                this.getInstance().uninstall();
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }

    private synchronized IDistro getInstance() throws Exception {
        if (this.flavorInstance == null) {
            LinuxPlatformRelease distro = LinuxPlatform.getRelease();
            IDistro instance = null;
            if (distro.getDistro() == LinuxDistroEnum.centos) {
                instance = new CentOS(this);
            } else if (distro.getDistro() == LinuxDistroEnum.rhel) {
                instance = new RHEL(this);
            } else if (distro.getDistro() == LinuxDistroEnum.debian) {
                instance = new Debian(this);
            } else if (distro.getDistro() == LinuxDistroEnum.ubuntu) {
                instance = new Ubuntu(this);
            }
            this.flavorInstance = instance;
        }
        return this.flavorInstance;
    }
}

