/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.license.validation;

import com.gamedash.daemon.license.LicenseValidationResult;
import com.gamedash.daemon.license.validation.IOnLicenseValidityChangeCallback;
import com.gamedash.daemon.license.validation.OnLicenseValidityChangeListener;
import com.gamedash.daemon.license.validation.PeriodicValidationManager;

public class LicenseValidationManager {
    private static PeriodicValidationManager periodicValidationManager;
    private static final OnLicenseValidityChangeListener onValidityChangeListener;

    public static void onValidityChange(IOnLicenseValidityChangeCallback callback) {
        onValidityChangeListener.addCallback(callback);
    }

    public static void invokeOnValidityChange(LicenseValidationResult result) {
        onValidityChangeListener.invokeAsync(result);
    }

    public static PeriodicValidationManager getPeriodicValidationManager() {
        if (periodicValidationManager == null) {
            periodicValidationManager = LicenseValidationManager.createPeriodicValidationManager();
        }
        return periodicValidationManager;
    }

    private static PeriodicValidationManager createPeriodicValidationManager() {
        return new PeriodicValidationManager();
    }

    static {
        onValidityChangeListener = new OnLicenseValidityChangeListener();
    }
}

