/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.infrastructure.node.self.status.handshake;

import com.gamedash.daemon.ConnectException;
import com.gamedash.daemon.common.listener.ListenerCallbackHandle;
import com.gamedash.daemon.infrastructure.node.self.status.StatusUpdateQuery;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.AttemptListener;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.CompleteListener;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.ErrorListener;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.IOnAttemptListenerCallback;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.IOnCompleteListenerCallback;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.IOnErrorListenerCallback;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.StatusHandshakeExceededRetriesException;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSession;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSessions;
import com.gamedash.daemon.infrastructure.node.status.NodeNotOnlineException;

public class StatusHandshake
implements Comparable<StatusHandshake> {
    private static final CompleteListener completeListener = new CompleteListener();
    private static final AttemptListener attemptListener = new AttemptListener();
    private static final ErrorListener errorListener = new ErrorListener();
    private final StatusHandshakeSession session;
    private long timeInitiated;
    private long timeTaken;
    private int attempts = 0;
    private int maxRetries = 3;
    private int retryTimeout = 5000;

    public StatusHandshake(StatusHandshakeSession session) {
        this.session = session;
    }

    public boolean initiate() throws Exception {
        this.updateTimeInitiated();
        this.attempt();
        this.updateTimeTaken();
        return true;
    }

    private void attempt() throws Exception {
        try {
            try {
                StatusHandshake.invokeOnAttempt(this, this.getAttempts());
                StatusUpdateQuery statusUpdateQuery = StatusUpdateQuery.create(this.session.isOnline());
                statusUpdateQuery.setHandshakeSession(this.session);
                statusUpdateQuery.registerErrorHandler(response -> {
                    String errorCode = response.getErrorCode();
                    String errorStatus = response.getStatus();
                    if (this.session.isOnline() && errorCode != null) {
                        if (errorCode.equalsIgnoreCase("INFRASTRUCTURE_NODE_STATUS_OFFLINE")) {
                            throw new NodeNotOnlineException(errorStatus);
                        }
                        if (errorCode.equalsIgnoreCase("NODE_DAEMON_CONNECT_EXCEPTION")) {
                            throw new ConnectException(errorStatus);
                        }
                    }
                });
                statusUpdateQuery.send();
            }
            catch (Throwable throwable) {
                StatusHandshake.invokeOnError(this, throwable);
                throw throwable;
            }
        }
        catch (ConnectException | NodeNotOnlineException e) {
            this.incrementRetries();
            if (this.hasExceededMaxRetries()) {
                throw new StatusHandshakeExceededRetriesException("Exceeded max status handshake retries");
            }
            Thread.sleep(this.getRetryTimeout());
            this.initiate();
        }
    }

    private void updateTimeInitiated() {
        this.setTimeInitiated(System.nanoTime());
    }

    private void setTimeInitiated(long time) {
        this.timeInitiated = time;
    }

    public long getTimeInitiated() {
        return this.timeInitiated;
    }

    public long getTimeTaken() {
        return this.timeTaken / 1000000L;
    }

    private void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    private void updateTimeTaken() {
        this.setTimeTaken(System.nanoTime() - this.getTimeInitiated());
    }

    public int getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(int timeout) {
        this.retryTimeout = timeout;
    }

    public int getAttempts() {
        return this.attempts;
    }

    private void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    private void incrementRetries() {
        this.setAttempts(this.getAttempts() + 1);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean hasExceededMaxRetries() {
        return this.getAttempts() > this.getMaxRetries();
    }

    public void setMaxRetries(int retries) {
        this.maxRetries = retries;
    }

    public void complete() {
        StatusHandshakeSessions.remove(this.getSession().getId());
        StatusHandshake.invokeOnComplete(this);
    }

    public StatusHandshakeSession getSession() {
        return this.session;
    }

    @Override
    public int compareTo(StatusHandshake b) {
        return this.getSession().getId().compareTo(b.getSession().getId());
    }

    public static ListenerCallbackHandle<IOnAttemptListenerCallback> onAttempt(IOnAttemptListenerCallback callback) {
        return attemptListener.addCallback(callback);
    }

    private static void invokeOnAttempt(StatusHandshake handshake, int attempt) {
        attemptListener.invoke(handshake, attempt);
    }

    public static ListenerCallbackHandle<IOnErrorListenerCallback> onError(IOnErrorListenerCallback callback) {
        return errorListener.addCallback(callback);
    }

    private static void invokeOnError(StatusHandshake handshake, Throwable throwable) {
        errorListener.invoke(handshake, throwable);
    }

    public static ListenerCallbackHandle<IOnCompleteListenerCallback> onComplete(IOnCompleteListenerCallback callback) {
        return completeListener.addCallback(callback);
    }

    private static void invokeOnComplete(StatusHandshake handshake) {
        completeListener.invoke(handshake);
    }

    public static StatusHandshake create(StatusHandshakeSession session) {
        return new StatusHandshake(session);
    }
}

