/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.fileSystem;

import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUser;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class FileHelpers {
    public static void ensureFileIsNotBlacklisted(RemoteFileSystemUser user, Path path) throws IOException {
        String fileExtension = Files.getFileExtension(path.toString());
        if (user.getFiles().getExtensions().getBlacklisted().contains(fileExtension)) {
            throw new IOException("File is blacklisted");
        }
    }

    public static boolean directoryIsChild(File parent, File child) throws IOException {
        parent = parent.getCanonicalFile();
        for (File parentFile = child = child.getCanonicalFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!parent.equals(parentFile)) continue;
            return true;
        }
        return false;
    }
}

