/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.hotlink;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.fileSystem.file.hotlink.FileSystemFileHotlink;
import com.gamedash.daemon.fileSystem.file.hotlink.FileSystemFileHotlinkException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSystemFileHotlinks {
    private static List<FileSystemFileHotlink> hotlinks = new ArrayList<FileSystemFileHotlink>();

    public static List<FileSystemFileHotlink> getAll() {
        return hotlinks;
    }

    public static FileSystemFileHotlink get(String id) {
        for (FileSystemFileHotlink hotlink : FileSystemFileHotlinks.getAll()) {
            if (!hotlink.getId().equals(id)) continue;
            return hotlink;
        }
        return null;
    }

    public static boolean exists(String id) {
        for (FileSystemFileHotlink hotlink : FileSystemFileHotlinks.getAll()) {
            if (!hotlink.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static void setAll(List<FileSystemFileHotlink> hotlinks) {
        FileSystemFileHotlinks.hotlinks = hotlinks;
    }

    public static void remove(String id) {
        for (FileSystemFileHotlink hotlink : FileSystemFileHotlinks.getAll()) {
            if (!hotlink.getId().equals(id)) continue;
            FileSystemFileHotlinks.remove(hotlink);
        }
    }

    public static void remove(FileSystemFileHotlink hotlink) {
        hotlinks.remove(hotlink);
    }

    public static FileSystemFileHotlink create(String id, boolean isDirectory, File file) throws FileSystemFileHotlinkException {
        if (FileSystemFileHotlinks.exists(id)) {
            throw new FileSystemFileHotlinkException("Hotlink " + id + " already exists");
        }
        FileSystemFileHotlink hotlink = new FileSystemFileHotlink(id, isDirectory, file);
        hotlinks.add(hotlink);
        return hotlink;
    }

    public static void update() throws Exception {
        ArrayList<FileSystemFileHotlink> hotlinks = new ArrayList<FileSystemFileHotlink>();
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/file/hotlink/all");
        QueryResponse queryResponse = query.get();
        for (JsonElement serializedHotlink : queryResponse.getJsonObject().get("response").getAsJsonArray()) {
            JsonObject serializedHotlinkObject = serializedHotlink.getAsJsonObject();
            String id = serializedHotlinkObject.get("id").getAsString();
            boolean isDirectory = serializedHotlinkObject.get("isDirectory").getAsBoolean();
            String path = serializedHotlinkObject.get("path").getAsString();
            FileSystemFileHotlink hotlink = FileSystemFileHotlink.createInstance(id, isDirectory, new File(path));
            hotlinks.add(hotlink);
        }
        FileSystemFileHotlinks.setAll(hotlinks);
    }
}

