/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container.event;

import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoImpl;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerAsyncEventsListener {
    private static final Logger logger = LoggerFactory.getLogger(DockerContainerIoImpl.class);
    private final DockerContainerImpl container;
    private Thread thread;

    public DockerContainerAsyncEventsListener(DockerImpl docker, DockerContainerImpl container) {
        this.container = container;
    }

    public Thread listen() {
        Thread thread = new Thread(() -> {
            try {
                this.container.getEvents().listen();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.start();
        this.setThread(thread);
        return thread;
    }

    public void destroy() {
        Thread thread = this.getThread();
        thread.interrupt();
    }

    public Thread ensureListening() {
        if (!this.container.getEvents().isListening()) {
            return this.listen();
        }
        return this.getThread();
    }

    public Thread getThread() {
        return this.thread;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }
}

