/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.common.singleton.SingletonList;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerBuilderImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerBuilderImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainersImpl;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerHostConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DockerContainersImpl
implements IDockerContainersImpl {
    private final SingletonList<DockerContainerImpl> containers = new SingletonList<DockerContainerImpl>(){

        @Override
        public boolean compare(DockerContainerImpl a, DockerContainerImpl b) {
            return a.getId().equals(b.getId());
        }
    };
    private final DockerImpl docker;

    public DockerContainersImpl(DockerImpl docker) {
        this.docker = docker;
    }

    @Override
    public List<IDockerContainerImpl> getAll() {
        return ((List)DockerImpl.getClient().listContainersCmd().withShowAll(true).exec()).stream().map(model -> {
            DockerContainerImpl container = (DockerContainerImpl)this.get(model.getId());
            DockerContainersImpl.applyModelToContainer(model, container);
            return container;
        }).collect(Collectors.toList());
    }

    @Override
    public List<IDockerContainerImpl> getRunning() {
        return ((List)DockerImpl.getClient().listContainersCmd().withShowAll(false).exec()).stream().map(model -> {
            DockerContainerImpl container = (DockerContainerImpl)this.get(model.getId());
            DockerContainersImpl.applyModelToContainer(model, container);
            return container;
        }).collect(Collectors.toList());
    }

    public IDockerContainerImpl get(String id) {
        return this.containers.handle(container -> container.getId().equals(id), () -> new DockerContainerImpl(this.docker, id));
    }

    @Override
    public IDockerContainerBuilderImpl create(String imageName) {
        return new DockerContainerBuilderImpl(imageName);
    }

    private static void applyModelToContainer(Container model, DockerContainerImpl container) {
        container.dataLayer.setValue("names", Arrays.asList(model.getNames()));
        container.dataLayer.setValue("images", model.getImage());
        container.dataLayer.setValue("imageId", model.getImageId());
        container.dataLayer.setValue("ports", model.getPorts());
        container.dataLayer.setValue("labels", model.getLabels());
        container.dataLayer.setValue("rootSize", model.getSizeRootFs());
        container.dataLayer.setValue("networkSettings", model.getNetworkSettings());
        container.dataLayer.setValue("mounts", model.getMounts());
        container.dataLayer.setValue("timeCreated", model.getCreated() != null ? Time.fromTimestamp(model.getCreated()) : null);
        ContainerHostConfig hostConfig = model.getHostConfig();
        if (hostConfig != null) {
            container.dataLayer.setValue("hostConfig.networkMode", hostConfig.getNetworkMode());
        }
    }
}

