/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container.registry;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DockerContainerRegistryFile.class);
    private static final List<DockerContainerRegistryFile> files = new ArrayList<DockerContainerRegistryFile>();
    private static DockerContainerRegistryFile defaultFile;

    public static DockerContainerRegistryFile getDefaultFile() {
        try {
            if (defaultFile == null) {
                defaultFile = DockerContainerRegistry.getFile("docker-container-registry.json");
                return defaultFile;
            }
            return defaultFile;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static synchronized DockerContainerRegistryFile getFile(String path) throws Exception {
        DockerContainerRegistryFile registryFile2;
        Path resolvedPath = DockerContainerRegistry.resolvePath(path);
        for (DockerContainerRegistryFile registryFile2 : files) {
            if (!registryFile2.getFile().toPath().equals(resolvedPath)) continue;
            return registryFile2;
        }
        File file = new File(resolvedPath.toString());
        if (!file.exists()) {
            Config.createFile(resolvedPath);
        }
        registryFile2 = new DockerContainerRegistryFile(file);
        files.add(registryFile2);
        return registryFile2;
    }

    private static Path resolvePath(String path) {
        return DockerContainerRegistry.resolvePath(Paths.get(path, new String[0]));
    }

    private static Path resolvePath(Path path) {
        Path rootPath = Paths.get(FileSystem.getRootDirectory().toString(), new String[0]);
        return rootPath.resolve(path);
    }
}

