/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.installer;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.installer.InstallerStateEnum;

public class Installer {
    public static InstallerStateEnum getState() throws Exception {
        if (!Config.fileExists("daemon.properties") || !Config.getDefaultFile().valueExists("install.state") || Config.getDefaultFile().getValue("install.state").equalsIgnoreCase("notInstalled")) {
            return InstallerStateEnum.notInstalled;
        }
        String stateString = Config.getDefaultFile().getValue("install.state");
        if (stateString.equalsIgnoreCase("inProgress")) {
            return InstallerStateEnum.inProgress;
        }
        if (stateString.equalsIgnoreCase("installed")) {
            return InstallerStateEnum.installed;
        }
        return InstallerStateEnum.notInstalled;
    }

    public static void setState(InstallerStateEnum state) throws Exception {
        Config.getDefaultFile().setValue("install.state", state.name());
    }

    public static boolean isInstalled() throws Exception {
        return Installer.getState() == InstallerStateEnum.installed;
    }

    public static boolean isUninstalled() throws Exception {
        return !Installer.isInstalled();
    }
}

