/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;

public class GetInfo
extends Route<Object> {
    private final SystemInfo systemInfo = new SystemInfo();

    public GetInfo(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Info execute() throws Exception {
        Info info = new Info();
        info.cpu.name = this.systemInfo.getHardware().getProcessor().getProcessorIdentifier().getName();
        info.cpu.physicalProcessorCount = this.systemInfo.getHardware().getProcessor().getPhysicalProcessorCount();
        info.cpu.logicalProcessorCount = this.systemInfo.getHardware().getProcessor().getLogicalProcessorCount();
        info.ram.total = this.systemInfo.getHardware().getMemory().getTotal();
        info.ram.swap = this.systemInfo.getHardware().getMemory().getVirtualMemory().getSwapTotal();
        for (HWDiskStore diskStore : this.systemInfo.getHardware().getDiskStores()) {
            Storage.Disk disk = new Storage.Disk(diskStore.getName(), diskStore.getModel(), diskStore.getSize());
            info.storage.disks.add(disk);
            for (HWPartition diskStorePartition : diskStore.getPartitions()) {
                Storage.Disk.Partition partition = new Storage.Disk.Partition();
                partition.identification = diskStorePartition.getIdentification();
                partition.name = diskStorePartition.getName();
                partition.uuid = diskStorePartition.getUuid();
                partition.type = diskStorePartition.getType();
                partition.mountPoint = diskStorePartition.getMountPoint();
                partition.major = diskStorePartition.getMajor();
                partition.minor = diskStorePartition.getMinor();
                partition.size = diskStorePartition.getSize();
                disk.partitions.add(partition);
            }
        }
        info.baseboard.model = this.systemInfo.getHardware().getComputerSystem().getBaseboard().getModel();
        info.baseboard.manufacturer = this.systemInfo.getHardware().getComputerSystem().getBaseboard().getManufacturer();
        info.operatingSystem.architecture = com.gamedash.daemon.system.OperatingSystem.getArchitecture().getName();
        return info;
    }

    static class OperatingSystem {
        @SerializedName(value="architecture")
        public String architecture;

        OperatingSystem() {
        }
    }

    static class Baseboard {
        @SerializedName(value="model")
        public String model;
        @SerializedName(value="manufacturer")
        public String manufacturer;

        Baseboard() {
        }
    }

    static class Storage {
        @SerializedName(value="disks")
        public List<Disk> disks = new ArrayList<Disk>();

        Storage() {
        }

        static class Disk {
            @SerializedName(value="name")
            public String name;
            @SerializedName(value="model")
            public String model;
            @SerializedName(value="size")
            public long size;
            @SerializedName(value="partitions")
            public List<Partition> partitions = new ArrayList<Partition>();

            public Disk(String name, String model, long size) {
                this.name = name;
                this.model = model;
                this.size = size;
            }

            static class Partition {
                @SerializedName(value="identification")
                public String identification;
                @SerializedName(value="name")
                public String name;
                @SerializedName(value="uuid")
                public String uuid;
                @SerializedName(value="type")
                public String type;
                @SerializedName(value="mountPoint")
                public String mountPoint;
                @SerializedName(value="size")
                public long size;
                @SerializedName(value="major")
                public int major;
                @SerializedName(value="minor")
                public int minor;

                Partition() {
                }
            }
        }
    }

    static class Ram {
        @SerializedName(value="total")
        public long total;
        @SerializedName(value="swap")
        public long swap;

        Ram() {
        }
    }

    static class Cpu {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="physicalProcessorCount")
        public int physicalProcessorCount;
        @SerializedName(value="logicalProcessorCount")
        public int logicalProcessorCount;

        Cpu() {
        }
    }

    static class Info {
        @SerializedName(value="cpu")
        public Cpu cpu = new Cpu();
        @SerializedName(value="ram")
        public Ram ram = new Ram();
        @SerializedName(value="storage")
        public Storage storage = new Storage();
        @SerializedName(value="baseboard")
        public Baseboard baseboard = new Baseboard();
        @SerializedName(value="operatingSystem")
        public OperatingSystem operatingSystem = new OperatingSystem();

        Info() {
        }
    }
}

