/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.status.handshake;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.StatusHandshake;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.StatusHandshakes;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSession;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSessionNotFoundException;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSessions;

public class CompleteHandshake
extends Route<Void> {
    private final Request request;
    private StatusHandshakeSession session;

    public CompleteHandshake(Request request, Response response) {
        super(request, response);
        this.request = request;
    }

    @Override
    public Void execute() throws Exception {
        StatusHandshake handshake = this.getHandshake();
        handshake.complete();
        return null;
    }

    public StatusHandshake getHandshake() throws RequestParameterException {
        return StatusHandshakes.get(this.getSession());
    }

    public StatusHandshakeSession getSession() throws RequestParameterException {
        if (this.session == null) {
            String id = this.getId();
            this.session = StatusHandshakeSessions.get(id);
        }
        return this.session;
    }

    @Override
    public void before() throws Exception {
        String id = this.getId();
        StatusHandshakeSession session = this.getSession();
        if (session == null) {
            throw new StatusHandshakeSessionNotFoundException("Status handshake with id " + id + " not found");
        }
    }

    private String getId() throws RequestParameterException {
        return this.request.getInput().getParameters().get("session_id").getValue();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"session_id"};
    }
}

