/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.relay.server.channel;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.BooleanRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.common.relay.payload.RelayPayload;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.relay.server.RelayServerInstanceNotFoundException;
import com.gamedash.daemon.relay.server.RelayServers;

public class BroadcastMessageToChannel
extends Route<Void> {
    public BroadcastMessageToChannel(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Void execute() throws Exception {
        String id = this.request.getInput().getParameters().get("id").getValue();
        String type = this.request.getInput().getParameters().get("type").getValue();
        String message = this.request.getInput().getParameters().get("message").getValue();
        String channelName = this.request.getInput().getParameters().get("channel_name").getValue();
        boolean shouldEncodeMessage = this.shouldEncodeMessage();
        RelayServer server = RelayServers.getInstanceById(id);
        RelayChannel channel = server.getChannels().acquire(channelName);
        RelayPayload<String> payload = RelayPayload.create(type);
        if (shouldEncodeMessage) {
            payload.setMessageAndEncode(message);
        } else {
            payload.setMessage(message);
        }
        channel.broadcast(payload);
        return null;
    }

    private boolean shouldEncodeMessage() {
        return this.request.getInput().getParameters().exists("encodeMessage") && this.request.getInput().getParameters().get("encodeMessage").getValue(new BooleanRequestParameterTransformer()) != false;
    }

    @Override
    public void before() throws Exception {
        String id = this.request.getInput().getParameters().get("instance_id").getValue();
        if (RelayServers.getInstanceById(id) == null) {
            throw new RelayServerInstanceNotFoundException("Instance " + id + " not found");
        }
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"instance_id", "channel_name", "type", "message"};
    }
}

