/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess.io;

import com.gamedash.daemon.api.server.model.process.childProcess.io.output.ChildProcessOutputItemModel;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class GetChildProcessOutput
extends Route<Result> {
    private ChildProcess childProcess;

    public GetChildProcessOutput(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        int id = this.getId();
        if (!ChildProcesses.exists(id)) {
            throw new ChildProcessNotFoundException("Process does not exist");
        }
        this.childProcess = ChildProcesses.get(id);
        Result result = new Result();
        result.items = this.getOutput().stream().map(ChildProcessOutputItemModel::new).collect(Collectors.toList());
        result.hasClosed = this.childProcess.getIo().hasClosed();
        return result;
    }

    private List<OutputItem> getOutput() {
        Integer tail = this.getTail();
        if (tail != null) {
            return this.childProcess.getIo().getOutputItems(tail);
        }
        Integer startIndex = this.getStartIndex();
        if (startIndex != null) {
            return this.childProcess.getIo().getOutputItemsStartingAtIndex(startIndex);
        }
        return this.childProcess.getIo().getOutputItems();
    }

    private Integer getTail() {
        return this.request.getInput().getParameters().exists("tail") ? this.request.getInput().getParameters().get("tail").getValue(new IntegerRequestParameterTransformer()) : null;
    }

    private Integer getStartIndex() {
        return this.request.getInput().getParameters().exists("startIndex") ? this.request.getInput().getParameters().get("startIndex").getValue(new IntegerRequestParameterTransformer()) : null;
    }

    private int getId() {
        return this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    protected static class Result {
        @SerializedName(value="items")
        public List<ChildProcessOutputItemModel> items;
        @SerializedName(value="hasClosed")
        public boolean hasClosed;

        protected Result() {
        }
    }
}

