/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.compression;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.compression.GZipArchive;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnGZip
extends Route<String>
implements FileSystemSystemUserTrait {
    public static final Logger logger = LoggerFactory.getLogger(UnGZip.class);

    public UnGZip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File output;
        File origin = this.getOrigin();
        File destination = this.getDestination();
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Origin file does not exist");
        }
        GZipArchive gZipArchive = GZipArchive.create(origin);
        if (destination == null) {
            output = gZipArchive.decompress();
        } else {
            if (!destination.exists() || !destination.isDirectory()) {
                throw new FileNotFoundException("Destination directory does not exist");
            }
            output = gZipArchive.decompress(destination);
        }
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            systemUser.assignFileSystemFilePermission(output);
        }
        return output.getPath();
    }

    private File getOrigin() throws RequestParameterException {
        return FileUtils.fromBase64(this.request.getInput().getParameters().get("origin").getValue());
    }

    private File getDestination() throws RequestParameterException {
        if (this.request.getInput().getParameters().exists("destination")) {
            return FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        }
        return this.getOrigin().getParentFile();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin"};
    }
}

