/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.compression;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class GetZipSize
extends Route<Long>
implements FileSystemSystemUserTrait {
    public static final Logger logger = LoggerFactory.getLogger(GetZipSize.class);

    public GetZipSize(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Long execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("File does not exist");
        }
        AtomicLong size = new AtomicLong(0L);
        ZipUtil.iterate(file, (in, zipEntry) -> size.addAndGet(zipEntry.getSize()));
        return size.longValue();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

