/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;

public class SHA1Checksum
extends Route<String> {
    public SHA1Checksum(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        return FileSystemHelpers.getSHA1Checksum(file);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

