/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;

public class GetInformation
extends Route<Information> {
    public GetInformation(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Information execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        Information information = new Information();
        information.canWrite = file.canWrite();
        information.canExecute = file.canExecute();
        information.canRead = file.canRead();
        return information;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }

    public static class Information {
        @SerializedName(value="canWrite")
        public boolean canWrite;
        @SerializedName(value="canExecute")
        public boolean canExecute;
        @SerializedName(value="canRead")
        public boolean canRead;
    }
}

