/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.image;

import com.gamedash.daemon.api.server.helpers.docker.image.DockerImageHelpers;
import com.gamedash.daemon.api.server.model.docker.image.DockerImageModel;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.image.DockerImage;

public class GetImage
extends Route<DockerImageModel> {
    private final Docker docker = Docker.getInstance();

    public GetImage(Request request, Response response) {
        super(request, response);
    }

    @Override
    public DockerImageModel execute() throws Exception {
        String imageId = this.request.getInput().getParameters().get("image_id").getValue();
        DockerImage image = this.docker.getImages().get(imageId);
        return new DockerImageModel(image);
    }

    @Override
    public void before() throws Exception {
        String imageId = this.request.getInput().getParameters().get("image_id").getValue();
        DockerImageHelpers.ensureExists(imageId);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"image_id"};
    }
}

