/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.model.process.childProcess;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.reference.ChildProcessReference;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class ChildProcessModel {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="isRunning")
    private boolean isRunning;
    @SerializedName(value="hasExited")
    private boolean hasExited;
    @SerializedName(value="isTerminating")
    private boolean isTerminating;
    @SerializedName(value="canInterrupt")
    private boolean canInterrupt;
    @SerializedName(value="isSelfManaged")
    private boolean isSelfManaged;
    @SerializedName(value="references")
    private List<String> references;
    @SerializedName(value="terminal")
    private TerminalModel terminal;
    @SerializedName(value="timestampCreated")
    private long timestampCreated;
    @SerializedName(value="process")
    private ProcessModel process;

    public ChildProcessModel(ChildProcess childProcess) throws Exception {
        this.id = childProcess.getId();
        this.isRunning = childProcess.isRunning();
        this.hasExited = childProcess.hasExited();
        this.references = childProcess.getReferences().getAllLocal().stream().map(ChildProcessReference::getName).collect(Collectors.toList());
        this.isTerminating = childProcess.isTerminating();
        this.isSelfManaged = childProcess.isSelfManaged();
        this.canInterrupt = childProcess.canInterrupt();
        this.terminal = new TerminalModel(childProcess.getTerminal().getInstance());
        this.timestampCreated = childProcess.getTimeCreated().getTimestamp();
        if (childProcess.isRunning()) {
            this.process = new ProcessModel(childProcess.getProcess());
        }
    }

    private static class TerminalModel {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="class")
        private String clazz;

        public TerminalModel(ITerminal terminal) {
            this.name = terminal.getClass().getSimpleName();
            this.clazz = terminal.getClass().getName();
        }
    }

    private static class ProcessModel {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="commandLine")
        private String[] commandLine;
        @SerializedName(value="workingDirectory")
        private String workingDirectory;

        public ProcessModel(IProcess process) throws Exception {
            this.name = process.getName();
            this.commandLine = process.getCommandLine();
            this.workingDirectory = process.getWorkingDirectory().toString();
        }
    }
}

