/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.NothingWrittenException;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private final AttributeKey ENCODER = new AttributeKey(this.getClass(), "encoder");
    private final AttributeKey DECODER = new AttributeKey(this.getClass(), "decoder");
    private final AttributeKey DECODER_OUT = new AttributeKey(this.getClass(), "decoderOut");
    private final ProtocolCodecFactory factory;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new NullPointerException("encoder");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) {
                return encoder;
            }

            public ProtocolDecoder getDecoder(IoSession session) {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(final Class<? extends ProtocolEncoder> encoderClass, final Class<? extends ProtocolDecoder> decoderClass) {
        if (encoderClass == null) {
            throw new NullPointerException("encoderClass");
        }
        if (decoderClass == null) {
            throw new NullPointerException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return (ProtocolEncoder)encoderClass.newInstance();
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return (ProtocolDecoder)decoderClass.newInstance();
            }
        };
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return (ProtocolEncoder)session.getAttribute(this.ENCODER);
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return (ProtocolDecoder)session.getAttribute(this.DECODER);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeEncoder(parent.getSession());
        this.disposeDecoder(parent.getSession());
        this.disposeDecoderOut(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        ProtocolDecoder decoder = this.getDecoder0(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        while (in.hasRemaining()) {
            int oldPos = in.position();
            try {
                ProtocolDecoderOutput protocolDecoderOutput = decoderOut;
                synchronized (protocolDecoderOutput) {
                    decoder.decode(session, in, decoderOut);
                }
                decoderOut.flush();
            }
            catch (Throwable t) {
                ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
                if (pde.getHexdump() == null) {
                    int curPos = in.position();
                    in.position(oldPos);
                    pde.setHexdump(in.getHexDump());
                    in.position(curPos);
                }
                decoderOut.flush();
                nextFilter.exceptionCaught(session, pde);
                if (!(t instanceof RecoverableProtocolDecoderException)) break;
                if (in.position() != oldPos) continue;
            }
            break;
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        if (!(writeRequest instanceof MessageWriteRequest)) {
            nextFilter.messageSent(session, writeRequest);
            return;
        }
        MessageWriteRequest wrappedRequest = (MessageWriteRequest)writeRequest;
        nextFilter.messageSent(session, wrappedRequest.getParentRequest());
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof IoBuffer || message instanceof FileRegion) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        ProtocolEncoder encoder = this.getEncoder0(session);
        ProtocolEncoderOutputImpl encoderOut = this.getEncoderOut(session, nextFilter, writeRequest);
        try {
            encoder.encode(session, message, encoderOut);
            encoderOut.flushWithoutFuture();
            nextFilter.filterWrite(session, new MessageWriteRequest(writeRequest));
        }
        catch (Throwable t) {
            ProtocolEncoderException pee = t instanceof ProtocolEncoderException ? (ProtocolEncoderException)t : new ProtocolEncoderException(t);
            throw pee;
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.getDecoder0(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            decoder.finishDecode(session, decoderOut);
        }
        catch (Throwable t) {
            ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
            throw pde;
        }
        finally {
            this.disposeEncoder(session);
            this.disposeDecoder(session);
            this.disposeDecoderOut(session);
            decoderOut.flush();
        }
        nextFilter.sessionClosed(session);
    }

    private ProtocolEncoder getEncoder0(IoSession session) throws Exception {
        ProtocolEncoder encoder = (ProtocolEncoder)session.getAttribute(this.ENCODER);
        if (encoder == null) {
            encoder = this.factory.getEncoder(session);
            session.setAttribute(this.ENCODER, encoder);
        }
        return encoder;
    }

    private ProtocolEncoderOutputImpl getEncoderOut(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        return new ProtocolEncoderOutputImpl(session, nextFilter, writeRequest);
    }

    private ProtocolDecoder getDecoder0(IoSession session) throws Exception {
        ProtocolDecoder decoder = (ProtocolDecoder)session.getAttribute(this.DECODER);
        if (decoder == null) {
            decoder = this.factory.getDecoder(session);
            session.setAttribute(this.DECODER, decoder);
        }
        return decoder;
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession session, IoFilter.NextFilter nextFilter) {
        ProtocolDecoderOutput out = (ProtocolDecoderOutput)session.getAttribute(this.DECODER_OUT);
        if (out == null) {
            out = new ProtocolDecoderOutputImpl(session, nextFilter);
            session.setAttribute(this.DECODER_OUT, out);
        }
        return out;
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(this.ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(this.DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Throwable t) {
            this.logger.warn("Falied to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private void disposeDecoderOut(IoSession session) {
        session.removeAttribute(this.DECODER_OUT);
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
            this.session = session;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }

        public WriteFuture flush() {
            Object encodedMessage;
            Queue<Object> bufferQueue = this.getMessageQueue();
            WriteFuture future = null;
            while ((encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                future = new DefaultWriteFuture(this.session);
                this.nextFilter.filterWrite(this.session, new EncodedWriteRequest(encodedMessage, future, this.writeRequest.getDestination()));
            }
            if (future == null) {
                future = DefaultWriteFuture.newNotWrittenFuture(this.session, new NothingWrittenException(this.writeRequest));
            }
            return future;
        }

        public void flushWithoutFuture() {
            Object encodedMessage;
            Queue<Object> bufferQueue = this.getMessageQueue();
            while ((encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                this.nextFilter.filterWrite(this.session, new EncodedWriteRequest(encodedMessage, null, this.writeRequest.getDestination()));
            }
        }
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;

        public ProtocolDecoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter) {
            this.session = session;
            this.nextFilter = nextFilter;
        }

        public void flush() {
            Queue<Object> messageQueue = this.getMessageQueue();
            while (!messageQueue.isEmpty()) {
                this.nextFilter.messageReceived(this.session, messageQueue.poll());
            }
        }
    }

    private static class MessageWriteRequest
    extends WriteRequestWrapper {
        private MessageWriteRequest(WriteRequest writeRequest) {
            super(writeRequest);
        }

        public Object getMessage() {
            return EMPTY_BUFFER;
        }
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        private EncodedWriteRequest(Object encodedMessage, WriteFuture future, SocketAddress destination) {
            super(encodedMessage, future, destination);
        }
    }
}

