/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.response;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.schokkerit.restapi.client.response.IQueryResponse;

public abstract class AbstractQueryResponse
implements IQueryResponse {
    private final String raw;
    private final int statusCode;

    public AbstractQueryResponse(String raw, int statusCode) {
        this.raw = raw;
        this.statusCode = statusCode;
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    @Override
    public boolean isJson() {
        try {
            this.getJsonObject();
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    @Override
    public JsonObject getJsonObject() {
        return !this.getRaw().equals("") ? new JsonParser().parse(this.getRaw()).getAsJsonObject() : null;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isError() {
        return this.statusCode >= 300 || this.statusCode < 200;
    }
}

