/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.ssh.server;

import com.gamedash.daemon.ssh.SSH;
import com.gamedash.daemon.ssh.server.SSHServerAlreadyRunningException;
import com.gamedash.daemon.ssh.server.SSHServerNotRunningException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHServer {
    private static final List<SSHServer> instances = new ArrayList<SSHServer>();
    private static final Logger logger = LoggerFactory.getLogger(SSHServer.class);
    private SshServer instance;
    private int port;
    private boolean isRunning = false;

    public void start() throws IOException {
        if (this.isRunning()) {
            throw new SSHServerAlreadyRunningException("Already running");
        }
        this.instance = SshServer.setUpDefaultServer();
        this.instance.setPort(this.getPort());
        this.instance.setPasswordAuthenticator(new PasswordAuthenticator(){

            @Override
            public boolean authenticate(String username, String password, ServerSession session) throws PasswordChangeRequiredException, AsyncAuthException {
                try {
                    return true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                    return false;
                }
            }

            @Override
            public boolean handleClientPasswordChangeRequest(ServerSession session, String username, String oldPassword, String newPassword) {
                return false;
            }
        });
        this.instance.setKeyPairProvider(new SimpleGeneratorHostKeyProvider(SSH.getHostKeyFile().toPath()));
        this.instance.start();
        this.instance.setShellFactory(new InteractiveProcessShellFactory());
        this.setIsRunning(true);
    }

    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new SSHServerNotRunningException("Server not running");
        }
        this.instance.stop();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static SSHServer createInstance() {
        SSHServer server = new SSHServer();
        instances.add(server);
        return server;
    }
}

