/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.client.channel.broadcast;

import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.relay.payload.message.MessageEncoder;
import com.gamedash.daemon.relay.client.channel.RelayChannel;
import com.gamedash.daemon.relay.client.channel.broadcast.IBroadcaster;
import com.gamedash.daemon.relay.host.RelayHost;
import com.gamedash.daemon.relay.host.RelayHosts;
import com.gamedash.daemon.relay.payload.RelayPayload;
import java.util.List;
import java.util.stream.Collectors;

public class ManagedBroadcaster
implements IBroadcaster {
    private final List<RelayChannel> channels;

    public ManagedBroadcaster(List<RelayChannel> channels) {
        this.channels = channels;
    }

    @Override
    public void broadcast(RelayPayload<?> message) throws Exception {
        final RelayHost host = RelayHosts.getPrimary();
        ApiQuery query = new ApiQuery("broadcast"){

            @Override
            public String getAddress() throws Exception {
                return this.getProtocol() + "://" + host.getNetwork().getDomain() + ":" + host.getNetwork().getApiPort() + "/" + this.getEndpoint();
            }

            @Override
            protected Boolean isSecure() {
                return host.getNetwork().apiIsSecure();
            }
        };
        query.getParameters().create("channel", this.channels.stream().map(RelayChannel::getName).collect(Collectors.joining(",")));
        query.getParameters().create("type", message.getType());
        query.getParameters().create("message", MessageEncoder.encode(message.getMessage()));
        query.post();
    }

    public static ManagedBroadcaster create(List<RelayChannel> channels) {
        return new ManagedBroadcaster(channels);
    }
}

