/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.linux;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.platform.linux.LinuxProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendant;
import com.gamedash.daemon.process.platform.linux.LinuxProcessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinuxProcessDescendants {
    private LinuxProcess rootProcess;
    private List<LinuxProcessDescendant> descendants = new ArrayList<LinuxProcessDescendant>();

    public LinuxProcessDescendants(LinuxProcess rootProcess) {
        this.rootProcess = rootProcess;
    }

    public List<LinuxProcessDescendant> getAll() throws Exception {
        for (LinuxProcessDescendant descendant : this.getImmediate().getAll()) {
            if (!this.isAdded(descendant)) {
                this.add(descendant);
            }
            if (descendant.isThread()) continue;
            this.addAll(LinuxProcessDescendants.find(descendant.getProcess()));
        }
        return this.descendants;
    }

    public DescendantsStruct getImmediate() throws Exception {
        DescendantsStruct descendants = new DescendantsStruct();
        for (IProcess iProcess : Processes.getAll()) {
            try {
                LinuxProcessDescendant descendant;
                Map<String, String> procFile = ((LinuxProcess)iProcess).readProcStatusFile();
                if (procFile.get("PPid").equals("0") && procFile.get("Tgid").equals("0") || !procFile.get("PPid").equals(Long.toString(this.rootProcess.getId())) || descendants.exists(descendant = new LinuxProcessDescendant((LinuxProcess)iProcess, false))) continue;
                descendants.add(descendant);
            }
            catch (ProcessNotFoundException procFile) {}
        }
        for (LinuxProcess linuxProcess : this.getThreads()) {
            LinuxProcessDescendant descendant = new LinuxProcessDescendant(linuxProcess, true);
            if (descendant.getProcess().equals(this.rootProcess) || descendants.exists(descendant)) continue;
            descendants.add(descendant);
        }
        return descendants;
    }

    public List<LinuxProcess> getThreads() throws Exception {
        ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
        File tasksDirectory = new File("/proc/" + this.rootProcess.getId() + "/task");
        if (!tasksDirectory.exists()) {
            throw new ProcessNotFoundException(this.rootProcess.getId());
        }
        try {
            File[] files = tasksDirectory.listFiles();
            if (files == null) {
                return processes;
            }
            for (File file : files) {
                if (!file.isDirectory()) continue;
                processes.add((LinuxProcess)Processes.get(Integer.parseInt(file.getName())));
            }
            return processes;
        }
        catch (FileNotFoundException exception) {
            throw new ProcessNotFoundException(this.rootProcess.getId());
        }
    }

    private boolean isAdded(LinuxProcessDescendant target) {
        for (LinuxProcessDescendant descendant : this.descendants) {
            if (descendant != target && descendant.getProcess().getId() != target.getProcess().getId()) continue;
            return true;
        }
        return false;
    }

    private void add(LinuxProcessDescendant descendant) {
        if (this.isAdded(descendant)) {
            throw new LinuxProcessException("Process " + descendant.getProcess().getId() + " already added as a descendant");
        }
        this.descendants.add(descendant);
    }

    private void addAll(List<LinuxProcessDescendant> processes) {
        for (LinuxProcessDescendant descendant : processes) {
            if (this.isAdded(descendant)) continue;
            this.add(descendant);
        }
    }

    public static List<LinuxProcessDescendant> find(LinuxProcess rootProcess) throws Exception {
        return new LinuxProcessDescendants(rootProcess).getAll();
    }

    public static class DescendantsStruct {
        private List<LinuxProcessDescendant> descendants = new ArrayList<LinuxProcessDescendant>();

        public List<LinuxProcessDescendant> getAll() {
            return this.descendants;
        }

        public void add(LinuxProcessDescendant descendant) {
            this.descendants.add(descendant);
        }

        public boolean exists(LinuxProcessDescendant descendant) {
            for (LinuxProcessDescendant _descendant : this.descendants) {
                if (!_descendant.equals(descendant)) continue;
                return true;
            }
            return false;
        }
    }
}

