/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.pty;

import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.generic.GenericTerminalIo;
import com.gamedash.daemon.process.childProcess.terminal.io.AbstractIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IQueuedInputStreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtyTerminalIo
extends AbstractIo
implements IIo,
IQueuedInputStreamListener {
    private static final Logger logger = LoggerFactory.getLogger(GenericTerminalIo.class);

    PtyTerminalIo(ChildProcess childProcess) throws Exception {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        if (!this.childProcess.isRunning()) {
            return;
        }
        OutputStream outputStream = this.childProcess.getApi(Process.class).getOutputStream();
        outputStream.write((value + "\r\n").getBytes());
        outputStream.flush();
    }

    @Override
    public void listen() {
        if (this.isListening()) {
            throw new ProcessException("Already listening to io");
        }
        this.setIsListening(true);
        this.getOutputQueueManager().createPool(1);
        new Thread(() -> {
            try {
                Thread inputStreamListenerThread = this.createThreadedInputStreamListener(this.getInputStream(), false);
                Thread errorStreamListenerThread = this.createThreadedInputStreamListener(this.getErrorStream(), true);
                inputStreamListenerThread.start();
                errorStreamListenerThread.start();
                inputStreamListenerThread.join();
                errorStreamListenerThread.join();
            }
            catch (Exception e) {
                if (e instanceof IOException && this.childProcess.isTerminating()) {
                    return;
                }
                logger.error(e.getMessage());
            }
            finally {
                this.setHasClosed(true);
                this.invokeOnCloseListener();
            }
        }).start();
    }

    @Override
    public void destroy() throws Exception {
        this.getOutputQueueManager().stopWorkersGracefully();
        this.getInputStream().close();
        this.getErrorStream().close();
    }

    private InputStream getInputStream() throws Exception {
        return this.childProcess.getApi(Process.class).getInputStream();
    }

    private InputStream getErrorStream() throws Exception {
        return this.childProcess.getApi(Process.class).getErrorStream();
    }
}

