/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.io;

import com.gamedash.daemon.common.listener.SimpleListener;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.IOnCloseCallback;
import com.gamedash.daemon.process.childProcess.io.IOnOutputCallback;
import com.gamedash.daemon.process.childProcess.io.Io;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.OnOutputListener;
import com.gamedash.daemon.process.childProcess.terminal.io.output.queue.OutputQueueManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIo
implements IIo {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractIo.class);
    private final OutputQueueManager outputQueueManager;
    private final int historySize = Io.getHistorySize();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition hasClosedSync = this.takeLock.newCondition();
    private volatile boolean hasClosed = false;
    private volatile long currentIndex;
    private volatile boolean listening = false;
    protected OnOutputListener onOutputListener = new OnOutputListener();
    protected SimpleListener onCloseListener = new SimpleListener();
    protected ChildProcess childProcess;
    protected BlockingQueue<OutputItem> outputItems = new ArrayBlockingQueue<OutputItem>(this.historySize);

    public AbstractIo(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.outputQueueManager = new OutputQueueManager(childProcess);
    }

    public long getCurrentIndex() {
        return this.currentIndex;
    }

    public synchronized void setCurrentIndex(long index) {
        this.currentIndex = index;
    }

    public synchronized long incrementCurrentIndex() {
        long index = this.getCurrentIndex() + 1L;
        this.setCurrentIndex(index);
        return index;
    }

    @Override
    public synchronized void addOutputItem(OutputItem outputItem) {
        if (this.outputItems.size() >= this.historySize) {
            this.outputItems.poll();
        }
        long index = this.incrementCurrentIndex();
        outputItem.setIndex(index);
        this.outputItems.add(outputItem);
    }

    @Override
    public List<OutputItem> getOutputItems() {
        return new ArrayList<OutputItem>(this.outputItems);
    }

    @Override
    public List<OutputItem> getOutputItems(int tail) {
        ArrayList<OutputItem> output = new ArrayList<OutputItem>(this.outputItems);
        return output.subList(Math.max(output.size() - tail, 0), output.size());
    }

    @Override
    public void onOutput(IOnOutputCallback callback) {
        this.onOutputListener.addCallback(callback);
    }

    @Override
    public List<CompletableFuture<Void>> invokeOnOutputListener(OutputItem item) {
        return this.onOutputListener.invokeAsync(item);
    }

    @Override
    public void onClose(IOnCloseCallback callback) {
        if (this.hasClosed()) {
            callback.invoke();
        }
        this.onCloseListener.addCallback(callback);
    }

    @Override
    public void waitFor() throws Exception {
        this.waitFor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor(Integer seconds) throws Exception {
        if (!this.isListening()) {
            logger.info(MessageFormat.format("Attempted to wait for IO for child process {0}, but we're not even listening", this.childProcess.getId()));
            return;
        }
        Condition condition = this.hasClosedSync;
        synchronized (condition) {
            while (!this.hasClosed()) {
                if (seconds != null) {
                    this.hasClosedSync.wait(seconds.intValue());
                    break;
                }
                this.hasClosedSync.wait();
            }
        }
    }

    @Override
    public List<CompletableFuture<Void>> invokeOnCloseListener() {
        return this.onCloseListener.invokeAsync();
    }

    @Override
    public OutputQueueManager getOutputQueueManager() {
        return this.outputQueueManager;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    protected void setIsListening(boolean listening) {
        this.listening = listening;
    }

    public boolean hasClosed() {
        return this.hasClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHasClosed(boolean closed) {
        Condition condition = this.hasClosedSync;
        synchronized (condition) {
            this.hasClosed = closed;
            this.hasClosedSync.notifyAll();
        }
    }
}

