/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.generic;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.generic.GenericTerminalIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTerminal
extends AbstractTerminal
implements ITerminal {
    public static final Logger logger = LoggerFactory.getLogger(GenericTerminal.class);
    private final IIo io;
    private final ChildProcess childProcess;
    private volatile int id;
    private Process api;

    public GenericTerminal(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.io = new GenericTerminalIo(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            processBuilder.directory(this.childProcess.getWorkingDirectory());
        }
        processBuilder.environment().putAll(this.childProcess.getEnvironmentVariables());
        this.api = processBuilder.start();
        ProcessHandle handle = this.api.toHandle();
        this.id = (int)handle.pid();
        this.getIo().listen();
        if (handle.isAlive()) {
            CompletableFuture<Process> onExit = this.api.onExit();
            onExit.thenAccept(_handle -> new Thread(this::handleExit).start());
        } else {
            this.handleExit();
        }
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        List<ProcessHandle> descendants = this.getDescendants();
        if (this.api.supportsNormalTermination()) {
            this.api.destroy();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroy);
            }
            this.waitForExit(5);
            this.api.destroyForcibly();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroyForcibly);
            }
        } else {
            this.api.destroyForcibly();
        }
        this.waitForExit();
    }

    @Override
    public List<ProcessHandle> getDescendants() {
        return this.api.descendants().collect(Collectors.toList());
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        if (this.api == null) {
            return false;
        }
        return this.api.isAlive();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }
}

