/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessStore;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.generic.GenericTerminal;
import java.util.ArrayList;
import java.util.List;

public class ChildProcesses {
    private static ChildProcessStore store = new ChildProcessStore();

    public static List<ChildProcess> getAll() {
        return ChildProcesses.getStore().getAll();
    }

    public static List<ChildProcess> getRunning() throws Exception {
        ArrayList<ChildProcess> processes = new ArrayList<ChildProcess>();
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.hasExited() || process.isTerminating()) continue;
            processes.add(process);
        }
        return processes;
    }

    public static void stopAll() throws Exception {
        for (ChildProcess childProcess : ChildProcesses.getAll()) {
            if (!childProcess.isRunning() || childProcess.isTerminating()) continue;
            childProcess.stop();
        }
    }

    public static ChildProcess create() throws Exception {
        return ChildProcesses.create(GenericTerminal.class);
    }

    public static ChildProcess create(Class<? extends ITerminal> terminalClass) throws Exception {
        ChildProcess process = new ChildProcess(terminalClass);
        ChildProcesses.getStore().add(process);
        return process;
    }

    public static ChildProcess get(int id) throws Exception {
        if (!ChildProcesses.exists(id)) {
            throw new Exception("Process with pid " + id + " does not exist");
        }
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != id) continue;
            return process;
        }
        throw new Exception("Could not get childProcess");
    }

    public static boolean exists(int id) throws Exception {
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != id) continue;
            return true;
        }
        return false;
    }

    public static void delete(ChildProcess childProcess) {
        ChildProcesses.getStore().remove(childProcess);
    }

    public static ChildProcessStore getStore() {
        return store;
    }

    public static void setStore(ChildProcessStore storage) {
        store = storage;
    }

    public static boolean childProcessesAreManaged() {
        return !ChildProcessStore.hasModifiedOrigin();
    }
}

