/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.system.user;

import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.system.user.WindowsSystemUserException;
import com.gamedash.daemon.system.user.ISystemUser;
import java.io.File;
import java.util.List;

public class WindowsSystemUser
implements ISystemUser {
    private final String name;

    public WindowsSystemUser(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteOperatingSystemUser(this.getName()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void setPassword(String password) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setOperatingSystemUserPassword(this.getName(), password));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void assignFileSystemFilePermission(File file) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().assignOperatingSystemUserPermissions(this.getName(), file.getPath()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void assignFileSystemFilePermission(List<File> files) throws Exception {
        for (File file : files) {
            this.assignFileSystemFilePermission(file);
        }
    }

    @Override
    public void setHomeDirectory(File directory) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setOperatingSystemUserHomeDirectory(this.getName(), directory.getPath()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }
}

