/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.bridge;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.platform.windows.bridge.IWindowsBridge;
import com.gamedash.daemon.system.OperatingSystem;
import com.gamedash.daemon.system.OperatingSystemArchitectureEnum;
import com.sun.jna.Native;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsBridge {
    private static IWindowsBridge instance;
    private static Logger logger;

    public static File getDllFile() {
        if (Application.args.windowsBridgePath != null) {
            return new File(Application.args.windowsBridgePath);
        }
        return new File(String.format(FileSystem.getRootDirectory().getPath() + File.separator + "WindowsBridge-%s.dll", OperatingSystem.getArchitecture().toString()));
    }

    public static synchronized IWindowsBridge getInstance() {
        if (instance == null) {
            File file = WindowsBridge.getDllFile();
            logger.info("Loading Windows bridge from " + file.getPath());
            instance = Native.load(file.getPath(), IWindowsBridge.class);
        }
        return instance;
    }

    public static boolean isInstalled() throws Exception {
        return WindowsBridge.getDependency().isInstalled();
    }

    public static void install() throws Exception {
        WindowsBridge.getDependency().getInstallManager().install();
    }

    private static Dependency getDependency() {
        return OperatingSystem.getArchitecture() == OperatingSystemArchitectureEnum.x64 ? Dependencies.get("WindowsBridge64") : Dependencies.get("WindowsBridge32");
    }

    static {
        logger = LoggerFactory.getLogger(WindowsBridge.class);
    }
}

