/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation.services;

import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.authentication.AuthenticationResult;
import com.gamedash.daemon.common.initialization.AsyncInitializer;
import com.gamedash.daemon.common.initialization.implementation.IInitializerImplementation;
import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.initialization.implementation.services.ChildProcessGlobalCrashManagerServiceInitializer;
import com.gamedash.daemon.initialization.implementation.services.FileSystemFileHotlinksServiceInitializer;
import com.gamedash.daemon.initialization.implementation.services.HttpApiServiceInitializer;
import com.gamedash.daemon.initialization.implementation.services.HttpsApiServiceInitializer;
import com.gamedash.daemon.initialization.implementation.services.RelayServiceInitializer;
import com.gamedash.daemon.initialization.implementation.services.RemoteFileSystemHostsServiceInitializer;
import java.util.ArrayList;
import java.util.List;

public class ServicesInitializer
extends InitializerImplementation {
    private final AsyncInitializer initializer = new AsyncInitializer(this.getImplementations());

    @Override
    public void initialize() throws Exception {
        this.initializer.initialize();
        super.initialize();
    }

    @Override
    public void destroy() throws Exception {
        this.initializer.destroy();
        super.destroy();
    }

    @Override
    public boolean isAvailable() throws Exception {
        AuthenticationResult result = Authentication.authenticate();
        return result.isValid();
    }

    private List<IInitializerImplementation> getImplementations() {
        return new ArrayList<IInitializerImplementation>(){
            {
                this.add(new ChildProcessGlobalCrashManagerServiceInitializer());
                this.add(new FileSystemFileHotlinksServiceInitializer());
                this.add(new RemoteFileSystemHostsServiceInitializer());
                this.add(new RelayServiceInitializer());
                this.add(new HttpApiServiceInitializer());
                this.add(new HttpsApiServiceInitializer());
            }
        };
    }
}

