/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization;

import com.gamedash.daemon.common.initialization.IInitializer;
import com.gamedash.daemon.common.initialization.implementation.IInitializerImplementation;
import com.gamedash.daemon.initialization.Initializer;
import com.gamedash.daemon.initialization.implementation.ApiClientInitializer;
import com.gamedash.daemon.initialization.implementation.CGroupsInitializer;
import com.gamedash.daemon.initialization.implementation.ChildProcessesInitializer;
import com.gamedash.daemon.initialization.implementation.ConfigInitializer;
import com.gamedash.daemon.initialization.implementation.DependenciesInitializer;
import com.gamedash.daemon.initialization.implementation.DockerContainersInitializer;
import com.gamedash.daemon.initialization.implementation.FileSystemInitializer;
import com.gamedash.daemon.initialization.implementation.KeyStoreInitializer;
import com.gamedash.daemon.initialization.implementation.LicenseInitializer;
import com.gamedash.daemon.initialization.implementation.NetworkInitializer;
import com.gamedash.daemon.initialization.implementation.ProcessorGovernorsInitializer;
import com.gamedash.daemon.initialization.implementation.WindowsPlatformInitializer;
import java.util.ArrayList;
import java.util.List;

public class InitializationManager {
    private static final List<IInitializerImplementation> implementations = new ArrayList<IInitializerImplementation>(){
        {
            this.add(new CGroupsInitializer());
            this.add(new ChildProcessesInitializer());
            this.add(new ApiClientInitializer());
            this.add(new ConfigInitializer());
            this.add(new DependenciesInitializer());
            this.add(new FileSystemInitializer());
            this.add(new KeyStoreInitializer());
            this.add(new LicenseInitializer());
            this.add(new NetworkInitializer());
            this.add(new ProcessorGovernorsInitializer());
            this.add(new WindowsPlatformInitializer());
            this.add(new DockerContainersInitializer());
        }
    };
    private static IInitializer initializer = Initializer.create(implementations);

    public static IInitializer getInitializer() {
        return initializer;
    }
}

