/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.repository.image;

import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.image.DockerImageImpl;
import com.gamedash.daemon.docker.implementation.generic.repository.DockerRepositoryImpl;
import com.gamedash.daemon.docker.implementation.generic.repository.image.DockerRepositoryImageImpl;
import com.gamedash.daemon.docker.implementation.interfaces.repository.image.IDockerRepositoryImageImpl;
import com.gamedash.daemon.docker.implementation.interfaces.repository.image.IDockerRepositoryImagesImpl;
import com.gamedash.daemon.docker.repository.image.DockerRepositoryImagePullException;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import java.util.List;
import java.util.stream.Collectors;

public class DockerRepositoryImagesImpl
implements IDockerRepositoryImagesImpl {
    private final DockerImpl docker;
    private final DockerRepositoryImpl repository;

    public DockerRepositoryImagesImpl(DockerImpl docker, DockerRepositoryImpl repository) {
        this.docker = docker;
        this.repository = repository;
    }

    @Override
    public List<IDockerRepositoryImageImpl> getByTag(String tag) {
        return this.docker.getImages().getByRepoTag(this.repository, tag).stream().map(image -> this.createInstance(((DockerImageImpl)image).model)).collect(Collectors.toList());
    }

    @Override
    public void pull() throws Exception {
        this.pull(null);
    }

    @Override
    public void pull(String tag) throws Exception {
        if (tag == null) {
            tag = "latest";
        }
        PullImageCmd pullImageCmd = DockerImpl.getClient().pullImageCmd(this.repository.getId());
        pullImageCmd.withTag(tag);
        final DockerRepositoryImagesImpl self = this;
        pullImageCmd.exec(new PullImageResultCallback(){

            @Override
            public void onNext(PullResponseItem item) {
                super.onNext(item);
                if (item.isErrorIndicated()) {
                    ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                    throw new DockerRepositoryImagePullException((String)(errorDetail != null ? errorDetail.getMessage() : "Could not pull image " + self.repository.getId()));
                }
            }
        }).awaitCompletion();
    }

    private DockerRepositoryImageImpl createInstance(Image model) {
        return new DockerRepositoryImageImpl(this.docker, this.repository, model);
    }
}

