/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.DockerContainerHostConfig;
import com.gamedash.daemon.docker.container.DockerContainerNetwork;
import com.gamedash.daemon.docker.container.DockerContainerPort;
import com.gamedash.daemon.docker.container.event.DockerContainerEvents;
import com.gamedash.daemon.docker.container.io.DockerContainerIO;
import com.gamedash.daemon.docker.container.mount.DockerContainerMount;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistry;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryFile;
import com.gamedash.daemon.docker.container.statistics.DockerContainerStatistics;
import com.gamedash.daemon.docker.implementation.interfaces.IDockerMountImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerNetworkImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerPortImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DockerContainer {
    private final IDockerContainerImpl implementation;
    private final DockerContainerIO io;
    private final DockerContainerEvents events;

    public DockerContainer(IDockerContainerImpl implementation) {
        this.implementation = implementation;
        this.io = new DockerContainerIO(this);
        this.events = new DockerContainerEvents(this);
    }

    public String getId() {
        return this.implementation.getId();
    }

    public List<String> getNames() throws Exception {
        return this.implementation.getNames();
    }

    public String getImage() throws Exception {
        return this.implementation.getImage();
    }

    public String getImageId() throws Exception {
        return this.implementation.getImageId();
    }

    public Map<String, String> getLabels() throws Exception {
        return this.implementation.getLabels();
    }

    public Long getRootSize() throws Exception {
        return this.implementation.getRootSize();
    }

    public List<DockerContainerPort> getPorts() throws Exception {
        return this.implementation.getPorts().stream().map(implementation -> new DockerContainerPort(this, (IDockerContainerPortImpl)implementation)).collect(Collectors.toList());
    }

    public List<DockerContainerMount> getMounts() throws Exception {
        return this.implementation.getMounts().stream().map(implementation -> new DockerContainerMount(this, (IDockerMountImpl)implementation)).collect(Collectors.toList());
    }

    public DockerContainerHostConfig getHostConfig() throws Exception {
        return new DockerContainerHostConfig(this, this.implementation.getHostConfig());
    }

    public List<DockerContainerNetwork> getNetworks() throws Exception {
        return this.implementation.getNetworks().stream().map(implementation -> new DockerContainerNetwork(this, (IDockerContainerNetworkImpl)implementation)).collect(Collectors.toList());
    }

    public void start() throws Exception {
        this.implementation.start();
    }

    public void stop() throws Exception {
        this.implementation.stop();
    }

    public void kill() throws Exception {
        this.implementation.kill();
    }

    public void remove() throws Exception {
        this.implementation.remove();
        DockerContainerRegistryFile registryFile = DockerContainerRegistry.getDefaultFile();
        if (registryFile != null) {
            registryFile.removeEntry(this);
            registryFile.commit();
        }
    }

    public boolean isRunning() throws Exception {
        return this.implementation.isRunning();
    }

    public DockerContainerIO getIo() {
        return this.io;
    }

    public DockerContainerEvents getEvents() {
        return this.events;
    }

    public DockerContainerStatistics queryStatistics() throws Exception {
        return this.getImplementation().queryStatistics();
    }

    public IDockerContainerImpl getImplementation() {
        return this.implementation;
    }

    public Time getTimeStarted() throws Exception {
        return this.implementation.getTimeStarted();
    }

    public Time getTimeCreated() throws Exception {
        return this.implementation.getTimeCreated();
    }
}

