/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.tukaani.xz.XZInputStream;

public class XZArchive {
    private final File input;

    public XZArchive(File input) {
        this.input = input;
    }

    public File decompress() throws Exception {
        return this.decompress(this.input.getParentFile());
    }

    public File decompress(File output) throws Exception {
        File outputFile = output;
        if (output.isDirectory()) {
            outputFile = new File(output, this.input.getName().substring(0, this.input.getName().length() - 3));
        }
        XZInputStream in = new XZInputStream(new FileInputStream(this.input));
        FileOutputStream out = new FileOutputStream(outputFile);
        IOUtils.copy(in, out);
        in.close();
        out.close();
        return outputFile;
    }

    public static XZArchive create(File file) {
        return new XZArchive(file);
    }
}

