/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarArchive {
    private final File input;

    public TarArchive(File input) {
        this.input = input;
    }

    public List<File> decompress(File directory) throws Exception {
        TarArchiveEntry entry;
        LinkedList<File> untarredFiles = new LinkedList<File>();
        FileInputStream is = new FileInputStream(this.input);
        TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
        while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
            File outputFile = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                if (!outputFile.exists() && !outputFile.mkdirs()) {
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
            } else {
                File parentFile = outputFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                IOUtils.copy(debInputStream, outputFileStream);
                ((OutputStream)outputFileStream).close();
            }
            untarredFiles.add(outputFile);
        }
        debInputStream.close();
        return untarredFiles;
    }

    public static TarArchive create(File file) {
        return new TarArchive(file);
    }
}

