/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class GZipArchive {
    private final File input;

    public GZipArchive(File input) {
        this.input = input;
    }

    public File decompress() throws Exception {
        return this.decompress(this.input.getParentFile());
    }

    public File decompress(File output) throws Exception {
        File outputFile = output;
        if (output.isDirectory()) {
            outputFile = new File(output, this.input.getName().substring(0, this.input.getName().length() - 3));
        }
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(this.input));
        FileOutputStream out = new FileOutputStream(outputFile);
        IOUtils.copy(in, out);
        in.close();
        out.close();
        return outputFile;
    }

    public static GZipArchive create(File file) {
        return new GZipArchive(file);
    }
}

