/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.client;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.common.relay.payload.RelayPayload;
import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.client.RelayClientChannelDirectory;
import com.gamedash.daemon.common.relay.server.client.RelayClientException;
import java.net.SocketAddress;
import java.util.UUID;

public class RelayClient {
    private final RelayServer server;
    private final SocketIOClient socketIOClient;

    public RelayClient(RelayServer server, SocketIOClient socketClient) {
        this.server = server;
        this.socketIOClient = socketClient;
    }

    public UUID getId() {
        return this.socketIOClient.getSessionId();
    }

    public RelayClientChannelDirectory getChannels() {
        return new RelayClientChannelDirectory(this.server, this);
    }

    public void delete() {
        if (!this.server.getClients().exists(this.getId())) {
            throw new RelayClientException("Client does not exist");
        }
        if (this.socketIOClient.isChannelOpen()) {
            this.socketIOClient.disconnect();
        }
        this.server.getClients().remove(this.getId());
        for (RelayChannel channel : this.getChannels().getAll()) {
            channel.getClients().remove(this.getId());
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.socketIOClient.getRemoteAddress();
    }

    public void sendEvent(String name, Object ... data) {
        this.socketIOClient.sendEvent(name, data);
    }

    public void sendMessage(RelayPayload<?> message) {
        this.sendEvent("message", message);
    }

    public boolean equals(RelayClient client) {
        return client.getId().equals(this.getId());
    }
}

