/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.channel.broadcast;

import com.gamedash.daemon.common.relay.payload.RelayPayload;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.channel.broadcast.IBroadcaster;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import java.util.List;

public class ManagedBroadcaster
implements IBroadcaster {
    private final List<RelayChannel> channels;

    public ManagedBroadcaster(List<RelayChannel> channels) {
        this.channels = channels;
    }

    @Override
    public void broadcast(RelayPayload<?> payload) {
        for (RelayChannel channel : this.getChannels()) {
            payload.setChannel(channel.getName());
            for (RelayClient client : channel.getClients().getAll()) {
                client.sendMessage(payload);
            }
        }
    }

    private List<RelayChannel> getChannels() {
        return this.channels;
    }

    public static ManagedBroadcaster create(List<RelayChannel> channels) {
        return new ManagedBroadcaster(channels);
    }
}

