/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.payload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gamedash.daemon.common.relay.payload.AbstractPayload;
import com.gamedash.daemon.common.relay.payload.message.MessageEncoder;
import com.google.gson.annotations.SerializedName;

public class RelayPayload<T>
extends AbstractPayload {
    @JsonProperty(value="channel")
    @SerializedName(value="channel")
    private String channel;
    @JsonProperty(value="type")
    @SerializedName(value="type")
    private final String type;
    @JsonProperty(value="message")
    @SerializedName(value="message")
    private String message;
    @JsonIgnore
    private transient T sourceMessage;

    public RelayPayload(String type) {
        this.type = type;
    }

    @JsonIgnore
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public T getSourceMessage() {
        return this.sourceMessage;
    }

    public void setSourceMessage(T message) {
        this.sourceMessage = message;
    }

    public void setMessageAndEncode(T message) {
        this.setSourceMessage(message);
        this.setMessage(MessageEncoder.encode(message));
    }

    @JsonIgnore
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static <T> RelayPayload<T> create(String type) {
        return new RelayPayload<T>(type);
    }
}

