/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.config;

import com.gamedash.daemon.common.cache.ICached;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.config.transformer.ITransformer;
import com.gamedash.daemon.common.config.transformer.ListTransformer;
import com.gamedash.daemon.common.config.transformer.StringTransformer;
import com.gamedash.daemon.common.config.transformer.Transformers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ConfigFile
implements ICached {
    private final File file;
    private final FileInputStream fileInputStream;
    private final Properties properties = new Properties();

    public ConfigFile(File file) throws IOException {
        this.file = file;
        this.fileInputStream = new FileInputStream(file);
        this.loadProperties();
    }

    public File getFile() {
        return this.file;
    }

    public String getValue(String name) throws Exception {
        return this.getValue(name, new StringTransformer());
    }

    public <T> T getValue(String name, Class<T> type) throws Exception {
        return this.getValue(name, Transformers.determineTransformerFromType(type));
    }

    public <T> T getValue(String name, ITransformer<T> transformer) throws Exception {
        if (!this.valueExists(name)) {
            throw new ConfigException("Config value '" + name + "' does not exist");
        }
        return transformer.to(this.properties.getProperty(name));
    }

    public List<String> getValueAsList(String name) throws Exception {
        return this.getValue(name, new ListTransformer());
    }

    public boolean valueExists(String name) {
        return this.properties.getProperty(name) != null;
    }

    public <T> void setValue(String name, T value) throws Exception {
        this.setValue(name, value, Transformers.determineTransformerFromType(value.getClass()));
    }

    public synchronized <T> void setValue(String name, T value, ITransformer<T> transformer) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            Properties properties = this.properties;
            properties.setProperty(name, transformer.from(value));
            properties.store(fileOutputStream, null);
        }
    }

    public void reload() {
        this.properties.clear();
    }

    private void loadProperties() throws IOException {
        this.loadProperties(this.properties);
    }

    private void loadProperties(Properties properties) throws IOException {
        properties.load(this.fileInputStream);
    }

    @Override
    public void clearCache() throws Exception {
        this.loadProperties();
    }

    public void delete() {
        this.file.delete();
    }

    public File toFile() {
        return this.file;
    }
}

