/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.exception;

import com.gamedash.daemon.common.api.server.ApiServerException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonExceptionSerializer
implements JsonSerializer<Exception> {
    @Override
    public JsonElement serialize(Exception exception, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonRootObject = new JsonObject();
        jsonRootObject.add("message", new JsonPrimitive(exception.getMessage()));
        JsonArray jsonStacktraceElementArray = new JsonArray();
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            jsonStacktraceElementArray.add(stackTraceElement.toString());
        }
        jsonRootObject.add("stackTrace", jsonStacktraceElementArray);
        if (exception instanceof ApiServerException && ((ApiServerException)exception).hasCode()) {
            jsonRootObject.add("code", new JsonPrimitive(((ApiServerException)exception).getCode()));
        }
        return jsonRootObject;
    }
}

