/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.client;

import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.config.Config;

public class ApiClientConfig {
    public static boolean isSecure() throws Exception {
        if (!Config.getDefaultFile().valueExists("api.client.security.enabled")) {
            return true;
        }
        return Config.getDefaultFile().getValue("api.client.security.enabled", Boolean.class);
    }

    public static void setIsSecure(boolean isSecure) throws Exception {
        Config.getDefaultFile().setValue("api.client.security.enabled", isSecure);
    }

    public static String getVersion() throws Exception {
        return Config.getDefaultFile().getValue("api.client.version");
    }

    public static boolean hasVersion() throws Exception {
        return Config.getDefaultFile().valueExists("api.client.version");
    }

    public static void setVersion(String version) throws Exception {
        Config.getDefaultFile().setValue("api.client.version", version);
    }

    public static String getDomain() throws Exception {
        return Config.getDefaultFile().getValue("api.client.domain");
    }

    public static boolean hasDomain() throws Exception {
        return Config.getDefaultFile().valueExists("api.client.domain");
    }

    public static void setDomain(String domain) throws Exception {
        Config.getDefaultFile().setValue("api.client.domain", domain);
    }

    public static ApiClientConfigValidationResult validate() throws Exception {
        if (!ApiClientConfig.hasVersion()) {
            return new ApiClientConfigValidationResult(false, "No version is set");
        }
        if (!ApiClientConfig.hasDomain()) {
            return new ApiClientConfigValidationResult(false, "No domain is set");
        }
        return new ApiClientConfigValidationResult(true);
    }
}

