/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system.storage;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.path.PathUtils;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;

public class GetPartitionForPath
extends Route<PartitionResult> {
    private final SystemInfo systemInfo = new SystemInfo();
    private String path;

    public GetPartitionForPath(Request request, Response response) {
        super(request, response);
    }

    @Override
    public PartitionResult execute() throws Exception {
        this.path = PathUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        HWPartition partition = this.getPartition();
        if (partition == null) {
            return null;
        }
        PartitionResult result = new PartitionResult();
        result.identification = partition.getIdentification();
        result.name = partition.getName();
        result.uuid = partition.getUuid();
        result.type = partition.getType();
        result.mountPoint = partition.getMountPoint();
        result.major = partition.getMajor();
        result.minor = partition.getMinor();
        result.size = partition.getSize();
        return result;
    }

    private HWPartition getPartition() {
        List<String> pathBits = Arrays.asList(StringUtils.split(this.path, File.separator));
        for (int i = 0; i < pathBits.size() + 1; ++i) {
            String path = String.join((CharSequence)File.separator, pathBits.subList(0, pathBits.size() - i));
            if (path.isEmpty()) {
                path = "/";
            }
            for (HWPartition partition : this.getPartitions()) {
                if (!partition.getMountPoint().equalsIgnoreCase(path)) continue;
                return partition;
            }
        }
        return null;
    }

    private List<HWPartition> getPartitions() {
        ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
        for (HWDiskStore diskStore : this.systemInfo.getHardware().getDiskStores()) {
            partitions.addAll(Arrays.asList(diskStore.getPartitions()));
        }
        return partitions;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }

    static class PartitionResult {
        @SerializedName(value="identification")
        public String identification;
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="uuid")
        public String uuid;
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="mountPoint")
        public String mountPoint;
        @SerializedName(value="size")
        public long size;
        @SerializedName(value="major")
        public int major;
        @SerializedName(value="minor")
        public int minor;

        PartitionResult() {
        }
    }
}

