/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.relay.server;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.relay.server.RelayServers;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class GetAllInstances
extends Route<List<InstanceResult>> {
    public GetAllInstances(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<InstanceResult> execute() throws Exception {
        return RelayServers.getInstances().stream().map(InstanceResult::new).collect(Collectors.toList());
    }

    protected static class InstanceResult {
        @SerializedName(value="id")
        private final String id;
        @SerializedName(value="port")
        private final int port;

        public InstanceResult(RelayServer server) {
            this.id = server.getId().toString();
            this.port = server.getPort();
        }

        public String[] getRequiredParameters() {
            return new String[]{"instance_id"};
        }
    }
}

