/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess.io;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class GetChildProcessOutput
extends Route<List<?>> {
    public GetChildProcessOutput(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ResponseOutputItem> execute() throws Exception {
        Integer tail;
        int id = this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer());
        Integer n = tail = this.request.getInput().getParameters().exists("tail") ? this.request.getInput().getParameters().get("tail").getValue(new IntegerRequestParameterTransformer()) : null;
        if (!ChildProcesses.exists(id)) {
            throw new Exception("Process does not exist");
        }
        ChildProcess childProcess = ChildProcesses.get(id);
        List<OutputItem> outputItems = tail != null ? childProcess.getIo().getOutputItems(tail) : childProcess.getIo().getOutputItems();
        return outputItems.stream().map(ResponseOutputItem::new).collect(Collectors.toList());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    private static class ResponseOutputItem {
        @SerializedName(value="index")
        private long index;
        @SerializedName(value="isError")
        private boolean isError;
        @SerializedName(value="value")
        private String value;
        @SerializedName(value="timestampCreated")
        private long timestampCreated;

        public ResponseOutputItem(OutputItem outputItem) {
            this.index = outputItem.getIndex();
            this.isError = outputItem.isError();
            this.value = outputItem.getValue();
            this.timestampCreated = outputItem.getTimeCreated().getTimestamp();
        }
    }
}

